<?php

namespace Wolfie\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('user_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function ads()
    {
        return $this->hasMany('Ad', 'client_id');
    }

    public function threads()
    {
        return $this->hasMany('Thread', 'client_id')->withPivot();
    }

    public function reviews()
    {
        return $this->morphMany('Reviews', 'authorable');
    }

    public function messages()
    {
        return $this->morphMany('Message', 'to');
    }

}